﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Towary" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">
    
    public class Porównanie : IComparer {

        char[] separator = new char[] { ':' };
    
        public int Compare(object x, object y) {
            string key1 = (string)x;
            string key2 = (string)y;

            string typ1 = key1.Split(separator)[0];
            string typ2 = key2.Split(separator)[0];
            
            int cmp;
            cmp = typ1.CompareTo(typ2);
            if (cmp != 0)
                return cmp;

            string def1 = key1.Split(separator)[1].Replace(" ", "");
            string def2 = key2.Split(separator)[1].Replace(" ", "");
            
            return def1.CompareTo(def2);
        }

    }
    
    public class Zapis : IComparable {
        readonly Magazyn magazyn;
        readonly string typ;
        readonly string definicja;
        readonly decimal wartość;
        readonly int numer;
        public bool Ostatni = false;

        public Zapis(Magazyn magazyn, string typ, string definicja, int numer, decimal wartość) {
            this.magazyn = magazyn;
            this.typ = typ;
            this.definicja = definicja;
            this.numer = numer;
            this.wartość = wartość;
        }

        public string Typ {
            get { return typ; }
        }

        public Magazyn Magazyn {
            get { return magazyn; }
        }

        public string DefinicjaToSort {
            get { return definicja.Replace(" ", ""); }
        }
        
        public string Definicja {
            get {
                if (definicja.Contains("_Z:")) {
                    return definicja.Split(new char[] { ':' })[1];
                }
                if (definicja.Contains("_")) {
                    string źródło = definicja.Split(new char[] { '_' })[0];
                    string def = definicja.Split(new char[] { '_' })[1];
                    return string.Format("{0}(do {1})", def, źródło);
                }
                else {
                    return definicja;
                }
            }
        }

        public decimal Wartość1 {
            get { return numer == 1 ? wartość : Soneta.Tools.Math.BlankDecimal; }
        }

        public decimal Wartość2 {
            get { return numer == 2 ? wartość : Soneta.Tools.Math.BlankDecimal; }
        }

        public decimal Wartość3 {
            get { return numer == 3 ? wartość : Soneta.Tools.Math.BlankDecimal; }
        }

        public int Numer {
            get { return numer; }
        }

        public int CompareTo(object obj) {
            Zapis z = (Zapis)obj;
            int cmp;
            cmp = Magazyn.CompareTo(z.Magazyn);
            if (cmp != 0)
                return cmp;            
            cmp = Typ.CompareTo(z.Typ);
            if (cmp != 0)
                return cmp;
            if(DefinicjaToSort.Contains("RAZEM"))
                return 1;
            if(z.DefinicjaToSort.Contains("RAZEM"))
                return -1;
            return DefinicjaToSort.CompareTo(z.DefinicjaToSort);
        }
    }

    FromTo okres;

    [Context]
    public FromTo Okres {
        get { return okres; }
        set { okres = value; }
    }

    Magazyn magazyn;

    [Context]
    public Magazyn Magazyn {
        get { return magazyn; }
        set { magazyn = value; }
    }

    HandelModule hm;
    MagazynyModule mm;
    SortedList list = new SortedList(new Porównanie());
    ArrayList arr = new ArrayList();

    void dc_ContextLoad(object sender, EventArgs e) {
        arr.Clear();
        hm = HandelModule.GetInstance(dc);
        mm = hm.Magazyny;

        if (Magazyn != null)
            sumujMagazyn(Magazyn);
        else {
            foreach (Magazyn magazyn in mm.Magazyny.GetGrantedView())
                sumujMagazyn(magazyn);
        }

        arr.Sort();
        Grid.DataSource = arr;
    }

    decimal suma;
    string kierunekD;

    void sumujMagazyn(Magazyn magazyn) {
        System.Diagnostics.Trace.WriteLine(magazyn);
        list.Clear();

        //
        // Wczytać dokumenty hurtem
        //
        SubTable st = new SubTable(mm.Handel.DokHandlowe.WgMagazyn[magazyn], Okres);
       Soneta.Business.View vw = st.CreateView();
        vw.Condition &= new FieldCondition.Equal("TypPartii", TypPartii.Magazynowy);
        vw.Condition &= new FieldCondition.NotEqual("KierunekMagazynu", KierunekPartii.Brak);
        foreach (DokumentHandlowy dok in vw) {
            if (dok.KierunekMagazynu == KierunekPartii.Przychód) {
                switch (dok.Definicja.MomentMagazynu) {
                    case MomentMagazynu.PodczasZatwierdzania:
                    case MomentMagazynu.ZaPomocąRezerwacji:
                        if (dok.Zatwierdzony)
                            dodajDokument(dok, dok.Suma.Netto);
                        break;
                    case MomentMagazynu.PodczasZapisu:
                        dodajDokument(dok, dok.Suma.Netto);
                        break;
                }
            }
        }

        //
        // Podsumować rozchody
        //
        st = mm.Obroty.WgMagazyn[magazyn];
        vw = st.CreateView();
        vw.Condition &= new FieldCondition.Contain("Data", Okres);
        vw.Condition &= new FieldCondition.NotEqual("Korekta", KorektaObrotu.StornoZasobu);
        vw.Condition &= new FieldCondition.Equal("Przychod.Typ", TypPartii.Magazynowy);
        foreach (Obrot ob in vw) {
            dodajDokument(ob.Rozchod.Dokument, ob.Przychod.Wartosc);
        }
        
        //
        // Przygotować dane do wydruku
        //
        suma = 0;
        kierunekD = "R";
        char[] separator = new char[] { ':' };
        char[] separatorSymbolu = new char[] { '_' };
        string symbolDef = string.Empty;
        string symbolGrupy = string.Empty;
        decimal sumaGrupy = 0;
        Zapis z = null;
        
        foreach (DictionaryEntry de in list) {
            string def = (string)de.Key;
            string kierunek = def.Split(separator)[0];
            string symbol = def.Split(separator)[1];
            if (symbol.Contains("_"))
                symbolDef = symbol.Split(separatorSymbolu)[0];
            else
                symbolDef = symbol;
            if (kierunekD != kierunek) {
                kierunekD = kierunek;
                z = new Zapis(magazyn,
                    symbolDef,
                    razem, 3, suma);
                z.Ostatni = true;
                arr.Add(z);
                suma = 0;
            }
            decimal d = (decimal)de.Value;
            arr.Add(new Zapis(magazyn,
                symbolDef,
                symbol, 1, d));
            suma += d;
            if (kierunek == "R") {
                if (symbolGrupy == string.Empty)
                    symbolGrupy = symbolDef;
                if (symbolGrupy != symbolDef) {
                    z = new Zapis(magazyn, symbolGrupy, symbolGrupy + "_Z:<strong><center>--- Razem w relacji do " + symbolGrupy + " ---</center></strong>", 2, sumaGrupy);
                    z.Ostatni = true;
                    arr.Add(z);
                    symbolGrupy = symbolDef;
                    sumaGrupy = 0;
                }
                sumaGrupy += d;
            }
        }
        z = new Zapis(magazyn, symbolDef, symbolDef + "_Z:<strong><center>--- Razem w relacji do " + symbolDef + " ---</center></strong>", 2, sumaGrupy);
        z.Ostatni = true;
        arr.Add(z);
        z = new Zapis(magazyn,
            symbolDef,
            razem, 3, suma);
        z.Ostatni = true;
        arr.Add(z);
        suma = 0;
        kierunekD = "P";
    }

    const string razem = "<strong><center>--- RAZEM ---</center></strong>";
    
    void dodajDokument(DokumentHandlowy dok, decimal value) {
        // Powinny być dodawane tylko dokumenty rozchodowe.
        if(dok.KierunekMagazynu != KierunekPartii.Rozchód)
            return;
        string symbol = string.Empty;
        symbol += dok.KierunekMagazynu == KierunekPartii.Brak ? "B" : (dok.KierunekMagazynu == KierunekPartii.Przychód ? "P" : "R");
        symbol += ":";
        if (dok.Definicja == dok.Module.DefDokHandlowych.KorektaPZWZ) {
            symbol += dok.Nadrzędne[TypRelacjiHandlowej.KorektaPWZ].DokumentKorygowanyPierwszy != null ?
                dok.Nadrzędne[TypRelacjiHandlowej.KorektaPWZ].DokumentKorygowanyPierwszy.Definicja.Symbol :
                dok.Nadrzędne[TypRelacjiHandlowej.KorektaPWZ].Definicja.Symbol;
            symbol += "_KWPZ";
        }
        else {
            if(dok.Korekta) {
                symbol += dok.DokumentKorygowanyPierwszy.Definicja.Symbol;
                symbol += "_" + dok.SymbolKorekty;
            }
            else
                symbol += dok.Definicja.Symbol;
        }
        object v = list[symbol];
        if (v == null)
            list[symbol] = value;
        else
            list[symbol] = value + (decimal)v;
    }

    void Grid_BeforeRow(object sender, RowEventArgs args) {
        Zapis zapis = (Zapis)args.Row;
        col1.BottomBorder = BorderStyles.Single;
        col2.BottomBorder = BorderStyles.Single;
        col3.BottomBorder = BorderStyles.Single;
        if (zapis.Ostatni) {
            switch (zapis.Numer) {
                case 1: col1.BottomBorder = BorderStyles.Double; break;
                case 2: col2.BottomBorder = BorderStyles.Double; break;
                case 3: col3.BottomBorder = BorderStyles.Double; break;
            }
        }
    }
    
</script>
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Podsumowanie obrotów wg definicji dok rozchod</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form action="#" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Podsumowanie obrotów wg definicji dok. rozchod.|Okres: {0}" DataMember0="FromTo" ></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel" GroupData0="Magazyn" GroupData1="Typ" GroupLine="Magazyn: {0} W relacji do: {1}" OnBeforeRow="Grid_BeforeRow">
            <Columns>
			<ea:GridColumn Runat="server" DataMember="Definicja" Caption="Symbol"></ea:GridColumn>
			<ea:GridColumn Runat="server" Align="Right" DataMember="Wartość1"
			               Format="{0:n}" Width="16" Caption="Wartość~ " id="col1"></ea:GridColumn>
            <ea:GridColumn Runat="server" Align="Right" DataMember="Wartość2" Width="16" Caption="Wartość~ "
			               Format="{0:n}" id="col2"></ea:GridColumn>
			<ea:GridColumn Runat="server" Align="Right" DataMember="Wartość3" Width="16" Caption="Wartość~ "
			               Format="{0:n}" id="col3"></ea:GridColumn>                        
            </Columns>
            </ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" PrintDate="true" PrintTime="true"></eb:ReportFooter>
		</form>
	</body>
</html>

